/** a linked queue class */
public class LinkedQueue implements Queue
{
   // data members
   protected ChainNode front;
   protected ChainNode rear;
   public int length;

   // constructors
   /** create an empty queue */
   public LinkedQueue(int initialCapacity)
   {
      // the default initial value of front is null
	  front = rear = null;
      this.length = 0;
   }

   public LinkedQueue()
   {
      this(0);
   }

   // methods
   /** @return true iff queue is empty */
   public boolean isEmpty()
   {
       return (front == null);
   }

   /** insert theElement at the rear of the queue */
   public void put(int theElement)
   {
      // create a node for theElement
      ChainNode p = new ChainNode(theElement, null);
	  length++;

      // append p to the chain
      if (front == null) front = p;		// empty queue
      else rear.next = p;               // nonempty queue
      rear = p;
   }

   /** remove an element from the front of the queue
     * @return removed element
     * @return null if the queue is empty */
   public int remove()
   {
      if (isEmpty()) return 0;
	  length--;
      int frontElement = front.element;
      front = front.next;
      return frontElement;
   }
}
